/**
* \file: AlsaAudioCommon.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: C. Gellner / ADIT/SW1 / cgellner@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_ALSAAUDIOCOMMON_H
#define CARPLAY_ALSAAUDIOCOMMON_H

#include <atomic>
#include <string>
#include <carplay_plugin.h>
#include <alsa/asoundlib.h>


namespace adit { namespace carplay
{

class AlsaAudioCommon
{
public :
	AlsaAudioCommon(bool inDumpConfiguration, bool inVerboseLogging, const IConfiguration& Config);
    ~AlsaAudioCommon();

public:
    /* to set configuration */
    void SetDir (snd_pcm_stream_t dir_);
    void SetFormat (snd_pcm_format_t format_);
	void SetChannels(unsigned int channels_);
    void SetRate (unsigned int rate_);
    void SetInitTout(int tout_);
	void SetIdealPeriodMs(unsigned int ideal_period_ms_);
	void SetBufferIdealPeriods (int buffer_ideal_periods_);
	void SetPrefillMs(int prefill_ms_);
	void SetRecoverDelayMs(unsigned int recover_delay_ms_);

    snd_pcm_uframes_t GetIdealPeriodMs();
    snd_pcm_uframes_t GetPrefillMs();

    int SetupPCM(const char *pcmname);
    void ReleasePCM();

    /* buffer has to contain all channels interleaved in the configured format */
    int ReadWrite(void *buffer, size_t len);

    int StopStreaming();
    int Delay(snd_pcm_sframes_t *delay);
    int SetThreadPriority(const char* threadName);

    void AbortStreaming() { aborted = 1; };
    void FlushBuffers();
    // private section
private:
    int CreateBuffers ();
    void ReleaseBuffers ();

    int PrefillSilence();
    int WaitPCM();
    int RwBuffer(void *buffer, snd_pcm_uframes_t xfer_size_);
    int Recover(int reset);

	/* configured by using application */
	snd_pcm_stream_t dir;
	snd_pcm_format_t format;/*format*/
	unsigned int channels; /* number of channels */
	unsigned int rate;	/*any, e.g. 8000-192000*/
	unsigned int ideal_period_ms;
	int buffer_ideal_periods;
	int prefill_ms;
	int recover_delay_ms;


	int init_tout;	/*timeout on snd_pcm_wait() until stream is active*/
	snd_pcm_uframes_t startup_xfer; /*sum of read/written frames- count up to buffer-size to detect device activity*/
	/* internally configured */
	snd_pcm_t *pcm;
	snd_pcm_access_t access;
	snd_pcm_uframes_t ideal_period_size;
	snd_pcm_uframes_t silence_prefill;

	snd_pcm_uframes_t buffer_size;
	snd_pcm_uframes_t period_size;

	unsigned int bytes_per_frame;

	void *silence_buffer;

	bool started;
	bool setup;
	bool broken;
	bool wait_done;

	bool dump_config;
	bool verbose;
	bool setThreadPrio;
	int threadPrio;

    int aborted;    /*flag indication streaming is aborted*/
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_ALSAAUDIOOUT_H */
